### Name: endpointCoordinates
### Title: Amounts in barytic-coordinates
### Aliases: endpointCoordinates endpointCoordinates.inv
###   endpointCoordinates.default endpointCoordinates.acomp
###   endpointCoordinates.aplus endpointCoordinates.rplus
###   endpointCoordinatesInv endpointCoordinatesInv.rmult
###   endpointCoordinatesInv.acomp endpointCoordinatesInv.aplus
###   endpointCoordinatesInv.rcomp endpointCoordinatesInv.rplus
### Keywords: multivariate

### ** Examples

data(SimulatedAmounts)
ep <- aplus(rbind(c(2,1,2),c(2,2,1),c(1,2,2)))
dat <- endpointCoordinatesInv(acomp(sa.lognormals),acomp(ep))
plot(dat)
plot( acomp(endpointCoordinates(dat,acomp(ep))))

dat <- endpointCoordinatesInv(rcomp(sa.lognormals),rcomp(ep))
plot(dat)
plot( rcomp(endpointCoordinates(dat,rcomp(ep))))

dat <- endpointCoordinatesInv(aplus(sa.lognormals),aplus(ep))
plot(dat)
plot( endpointCoordinates(dat,aplus(ep)))

dat <- endpointCoordinatesInv(rplus(sa.lognormals),rplus(ep))
plot(dat)
plot(endpointCoordinates(rplus(dat),rplus(ep)))




