\name{clr}
\alias{ult}
\alias{ult.inv}
\alias{Kappa}
\title{Uncentered log transform}
\description{
  Compute the uncentered log ratio transform of a (dataset of)
  compositions and its inverse.
}
\usage{
          ult( x )
          ult.inv( z )
          Kappa( x )
          }
\arguments{
  \item{x}{a composition or a data.matrix of compositions, not necessarily closed}
  \item{z}{the ult-transform of a composition or  a data.matrix of
    clr-transforms of compositions, not necessarily centered}
}
\value{
  \code{ult} gives the uncentered log transform,\cr
  \code{ult.inv} gives closed compositions with with the given
  ult-transforms\cr
  \code{Kappa} gives the difference between the clr and the ult
  transform. It is quite linked to information. 
  }
\details{
  The ult-transform is simply the elementwise log of the close
  composition. The ult has some important information theoretic
  properties. 
  
}
\seealso{
  \code{\link{ilr}},\code{\link{alr}},\code{\link{apt}}
}
\examples{
(tmp <- ult(c(1,2,3)))
ult.inv(tmp)
ult.inv(tmp) - clo(c(1,2,3)) # 0
data(Hydrochem)
cdata <- Hydrochem[,6:19]
pairs(ult(cdata)) 
Kappa(c(1,2,3))
}
\keyword{multivariate}
