\name{rcomparithm}
\alias{+.rplus}
\alias{-.rplus}
\alias{*.rplus}
\alias{/.rplus}
\alias{mul.rplus}
\title{Arithmetik of rplus-scale}
\description{
  The positive quadrant forms a mannifold of real vector space. The
  induced operations +,-,*,/give vector space valued results. 
}
\synopsis{
x+y
x-y
x*y
x/y
mul.rplus(x,alpha)
}
\usage{
   x+y
   x-y
   -x
   x*r
   r*x
   x/r
mul.rplus(x,r)

          }
\arguments{
  \item{x}{an rplus composition or dataset of compositions }
  \item{y}{an rplus composition or dataset of compositions }
  \item{r}{a numeric vector of size 1 or nrow(x)}
}
\value{
  \code{rmult}-objects containing the given operations on the rcomp
  mannifold as subset of the \eqn{R^D}. Only the addition and
  multiplication with positive numbers are closed
  operation and results in an \code{rplus}-object again.
}
\details{
  The functions behave quite like \code{\link{+.rmult}}.\cr
  The convex combination is defined as: \code{x*alpha + (1-alpha)*y}
}
\note{For \code{*} the arguments x and y can be exchanged.}
\seealso{
  \code{\link{+.rmult}}, \code{\link{+.acomp}},\code{\link{cpt}}, \code{\link{rcomp}}, \code{\link{rmult}}
}

\examples{
rplus(1:5)* -1 + rplus(1:5)
data(SimulatedAmounts)
cdata <- rplus(sa.lognormals)
plot( tmp <- (cdata-mean(cdata))/msd(cdata) )
class(tmp)
mean(tmp)
msd(tmp)
var(tmp)
}
\keyword{multivariate}
