\name{rplus}
\alias{rplus}
\title{Amounts i.e. positive numbers analysed in real-scale}
\description{
  A class to analyse positive amounts in a non logistic framework.
}
\usage{
          rplus(X,parts=1:NCOL(X),total=NA)
          }
\arguments{
  \item{X}{vector or dataset of positive numbers considered as amounts}
  \item{parts}{vector containing the indices  xor names of the columns to be used}
  \item{total}{a numeric vectors giving the total amounts of each dataset. }
}
\value{
  a vector of class \code{"rplus"} representing one vector of amounts
  or a matrix of class \code{"rplus"} representing
  multiple vectors of amounts each in one row.  
}
\details{
  Many multivariate datasets essentially discribe amounts of D different
  parts in a whole. When the whole is large in relation to the
  considered parts, such that they don't extrude each other, and when
  the total amount of each componenten is indeed determined by the
  phenomenon under investigation and not by artefacts such as dilution
  or sample preparation, then the parts can be treated as amounts rather
  than as a composition (cf. \code{\link{rcomp}}, \code{\link{aplus}}).
  \cr
  In principle amounts are just real scaled numbers with the only
  restriction that they are nonnegative. Thus they can be analysed by
  any multivariate analysis method. This class provides a simple access
  interface to do exactly that. It tries to keep in mind the positivity
  property of amounts and the special point zero. However there are
  strong arguments why an analyis based on log-scale might be much more
  adapted to the problem. This log-approach is provided by the class
  \code{\link{aplus}}. 

  The classes rcomp, acomp, aplus, and rplus are designed as similar as
  possible in order to allow direct comparison between results achieved  
  by the different approaches. Especially the aplus logistic transform
  \code{\link{ilt}} is mirrored
  by the simple identity transform \code{\link{iit}}. However in terms
  of computer science this identity mapping is realy mapping an object
  of type "rplus" to a classless datamatrix. 

  

}
\seealso{
  \code{\link{iit}},\code{\link{rcomp}}, \code{\link{aplus}},
  \code{\link{princomp.rplus}}, \code{\link{ClusterAnalysis.rplus}},
  \code{\link{plot.rplus}}, \code{\link{boxplot.rplus}},
  \code{\link{barplot.rplus}}, \code{\link{mean.rplus}},
  \code{\link{var.rplus}}, \code{\link{variation.rplus}},
  \code{\link{cov.rplus}}, \code{\link{msd}}
}

\references{

}
\examples{
data(SimulatedAmounts)
plot(rplus(sa.lognormals))

}
\keyword{multivariate}
