\name{rmultscalarproduct}
\alias{\%*\%.rmult}
\title{inner product for datasets with vector scale}
\description{
An rmult object is considered as a sequence of vectors. The \code{\%*\%}
is considered as the inner multiplication. An inner multiplication with
another vector is the scalar product. an inner multiplication with
a matrix is a matrix multiplication, where the rmult-vectors are either
considered as row or as column vector.  
}
\synopsis{
x \method{\%*\%}{rmult}y
}
\usage{
  x \method{\%*\%}{rmult} y
  x \method{\%*\%}{rmult} v
  v \method{\%*\%}{rmult} x
  x \method{\%*\%}{rmult} A
  A \method{\%*\%}{rmult} x 
}
\arguments{
  \item{x}{an rmult vector or dataset of vectors }
  \item{y}{an rmult vector or dataset of vectors }
  \item{v}{a numeric vector of length \code{gsi.getD(x)}}
  \item{w}{a numeric vector of length \code{gsi.getD(x)}}
  \item{A}{a matrix}
}
\value{
  an object of class \code{"rmult"} or a numeric vector containing the
result of the
corresponding inner products.
}

\details{ The operators try to minic the behavior of \code{\%*\%} on
\code{c()}-vectors as inner product parallelly applied to all vectors of
the dataset. Thus the product of a vector with an other \code{rmult}
object or unclassed vector \var{v} results in the scalar product. For
the multiplication with a matrix each vector is considered as a row or
column, whatever is appropriate. 
}
\note{The product \code{x \%*\% A \%*\% y} is assoziative. }

\seealso{
  \code{\link{rmult}}, \code{\link{\%*\%.rmult}}
}

\examples{
x <- rmult(matrix( sqrt(1:12), ncol= 3 ))
x\%*\%x
A <- matrix( 1:9,nrow=3)
x \%*\% A \%*\% x
x \%*\% A
A \%*\% x
x \%*\% 1:3
x \%*\% 1:3
1:3 \%*\% x 

}
\keyword{multivariate}
