\name{rcomparithm}
\alias{+.rcomp}
\alias{-.rcomp}
\alias{*.rcomp}
\alias{/.rcomp}
\alias{convex.rcomp}
\title{Arithmetik of rcomp-scale}
\description{
  The real compositions form a mannifold of real vector space. The
  induced operations +,-,*,/give vector space valued results. 
}
\synopsis{
x+y
x-y
x*y
x/y
convex.rcomp(x,y,alpha=0.5)
}
\usage{
   x+y
   x-y
   -x
   x*r
   r*x
   x/r
convex.rcomp(x,y,alpha=0.5)

          }
\arguments{
  \item{x}{an rcomp composition or dataset of compositions }
  \item{y}{an rcomp composition or dataset of compositions }
  \item{r}{a numeric vector of size 1 or nrow(x)}
  \item{alpha}{a numeric vector of size 1 or nrow(x) with values between
  0 and 1}
}
\value{
  \code{rmult}-objects containing the given operations on the rcomp
  mannifold as subset of the \eqn{R^D}. Only the convex combination
  \code{convex.rcomp} results in an \code{rcomp}-object again, since
  only this operation is closed.
}
\details{
  The functions behave quite like \code{\link{+.rmult}}.\cr
  The convex combination is defined as: \code{x*alpha + (1-alpha)*y}
}
\note{For \code{*} the arguments x and y can be exchanged.}
\seealso{
  \code{\link{+.rmult}}, \code{\link{+.acomp}},\code{\link{cpt}}, \code{\link{rcomp}}, \code{\link{rmult}}
}

\examples{
rcomp(1:5)* -1 + rcomp(1:5)
data(SimulatedAmounts)
cdata <- rcomp(sa.lognormals)
plot( tmp <- (cdata-mean(cdata))/msd(cdata) )
class(tmp)
mean(tmp)
msd(tmp)
var(tmp)
plot(convex.rcomp(rcomp(c(1,1,1)),sa.lognormals,0.1))
}
\keyword{multivariate}
