\name{rcomp}
\alias{rcomp}
\title{Compositions as elements of the D-1 dimensional Simplex}
\description{
  A class providing the means to analyse compositions in the
  philosophical framework of the Simplex as subset of the \eqn{R^D}.
}
\usage{
          rcomp(X,parts=1:NCOL(X),total=1)
          }
\arguments{
  \item{X}{composition or dataset of compositions}
  \item{parts}{vector containing the indices  xor names of the columns
    to be used}
  \item{total}{the total amount to be used, typically 1 or 100}

}
\value{
  a vector of class \code{"rcomp"} representing one closed compositions
  or a matrix of class \code{"rcomp"} representing
  multiple closed compositions each in one row.  
}
\details{
  Many multivariate datasets essentially discribe amounts of D different
  parts in whole. This has some important implications justifying to
  regard them as a scale for its own, called a
  composition.
  The functions around the class \code{"rcomp"} follow the traditional
  but statistically inconsistent approach regarding compositions simply
  as a multivariate vector of positive numbers summing to 1. This space of
  D positive numbers summing to 1 is traditionally called the D-1-dimensional
  simplex.

  The compositional scale was in depth analysed by Aitchison
  (1986) and he found serious resons why compositional data should be
  analysed a different geometry.  The functions around the class
  \code{"\link{acomp}"} follow his
  approach. However the Aitchison approach based on log-ratios is 
  sometimes criticized (e.g. Rehder&Zier): It can't deal with 
  absent parts (i.e. zeros). It is confused by large measurement errors
  in small amounts. The Aitchison operations can not represent simple
  mixing of different chemical compositions. The used transformations
  are not uniformly continues. Straight lines and ellipses in Aitchison
  space look strange in ternary diagrams. As all uncritical statistical
  analysis blind application of log-ratio based analysis is sometimes
  misleading. Therefore it is sometimes usefull to analyse
  compositional data directly as a multivariate dataset of portions
  summing to 1. However a clear warning must be given that the
  utilisation of almost any kind of
  classical multivariate analysis introduce some kinds of artefacts
  (e.g. Chayes 1960) when applied to compositional data. So extra care
  and considerable expert knowlegde is needed for the proper
  interpretation of results achieved in this non-Aitchison-approach. The
  package tries to lead the user around these artefacts as much as
  possible and to gives hints to major pitfalls in the help. However
  meaningless results cannot be fully avoided in this inconsistent approach. 
  \cr
  A sideeffect of the procedure is to force the compositions to sum to
  1 like it is done by the closure  operation \code{\link{clo}} . 
  \cr
  The classes rcomp, acomp, aplus, and rplus are designed as similar as
  possible in order to allow direct comparison between results achieved  
  by the different approaches. Especially the acomp logistic transforms
  \code{\link{clr}}, \code{\link{alr}}, \code{\link{ilr}} are mirrored
  by analogous linear transforms \code{\link{cpt}}, \code{\link{apt}},
  \code{\link{ipt}}. 

}
\seealso{
  \code{\link{cpt}}, \code{\link{apt}}, \code{\link{ipt}},
  \code{\link{acomp}}, \code{\link{rplus}},
  \code{\link{princomp.rcomp}}, \code{\link{ClusterAnalysis.rcomp}},
  \code{\link{plot.rcomp}}, \code{\link{boxplot.rcomp}},
  \code{\link{barplot.rcomp}}, \code{\link{mean.rcomp}},
  \code{\link{var.rcomp}}, \code{\link{variation.rcomp}},
  \code{\link{cov.rcomp}}, \code{\link{msd.rcomp}},
  \code{\link{convex.rcomp}}, \code{\link{add.rcomp}} 
}

\references{
  Aitchison, J. (1986) \emph{The Statistical Analysis of Compositional
    Data} Monographs on Statistics and Applied Probability. Chapman &
  Hall Ltd., London (UK). 416p.\cr

  Zier Rehder

}
\examples{
data(SimulatedAmounts)
plot(rcomp(sa.tnormals))
}
\keyword{multivariate}
