\name{acompscalarproduct}
\alias{\%*\%.acomp}
\alias{\%*\%.aplus}
\title{inner product for datasets with vectorspace scale}
\description{
  
acomp and aplus objects are considered as (sequences of) vectors. The
\code{\%*\%} is considered as the inner multiplication. An inner
multiplication with another vector is the scalar product. An inner
multiplication with a matrix is a matrix multiplication, where the
vectors are either considered as row or as column vector.

}
\synopsis{
x\method{\%*\%}{acomp}y
x\method{\%*\%}{aplus}y
}
\usage{
  x \method{\%*\%}{acomp} y
  x \method{\%*\%}{acomp} A
  A \method{\%*\%}{acomp} x
  x \method{\%*\%}{aplus} y
  x \method{\%*\%}{aplus} A
  A \method{\%*\%}{aplus} x
}
\arguments{
  \item{x}{a acomp or aplus object }
  \item{y}{a acomp or aplus object}
  \item{A}{a matrix interpreted in clr, ilr or ilt coordinates}
}
\value{
  Either a numeric vector containing the scalar products or an object of
  type acomp or aplus containing the vectors transformed with the given
  matrix. 
}

\details{ The operators try to minic the behavior of \code{\%*\%} on
\code{c()}-vectors as inner product parallelly applied to all vectors of
the dataset. Thus the product of a vector with an vector of the same
type results in the scalar product. For the multiplication with a matrix
each vector is considered as a row or column, whatever is
appropriate. The matrix itself is considered as representing a linear
mapping of the vector space to a space of the same type. The mapping is
represented in clr, ilr or ilt coordinates. Which of the aforementioned
coordinate systems is used is judged from the type of \var{x} and from
the dimensions of the \var{A}. 
} 
\seealso{
  \code{\link{\%*\%.rmult}}
}

\examples{
x <- acomp(matrix( sqrt(1:12), ncol= 3 ))
x\%*\%x
A <- matrix( 1:9,nrow=3)
x \%*\% A \%*\% x
x \%*\% A
A \%*\% x
A <- matrix( 1:4,nrow=2)
x \%*\% A \%*\% x
x \%*\% A
A \%*\% x
x <- aplus(matrix( sqrt(1:12), ncol= 3 ))
x\%*\%x
A <- matrix( 1:9,nrow=3)
x \%*\% A \%*\% x
x \%*\% A
A \%*\% x
}
\keyword{multivariate}
