\name{clo}
\alias{clo}
\title{Closure of a composition}
\description{
  Closes  compositions to sum up to one by dividing each part by the sum.
}
\usage{
          clo( X, parts=1:NCOL(X),total=1)
          }
\arguments{
  \item{X}{composition or dataset of compositions}
  \item{parts}{vector containing the indices xor names of the columns to be
    used}
  \item{total}{The total amount the compositions should be closed
    to. Either a single number, or numeric vector of size
    \code{gsi.getN(X)} spezifying a different total for each.}
}
\value{
  a composition or a datamatrix of compositions without compositional
  class. The individual compositions are forced to sum to 1. The result
  should have the same shape as the input (vector, row, matrix). 
}
\details{
  The closure operation is given by
  \deqn{ clo(x) := \left(x_i / \sum_{j=1}^D  x_j\right) }{
    clo(x) := ( \emph{x_i} / sum(x_j))}
  \code{clo} makes a composition without assigning one of the
  compositional classes \code{\link{acomp}} or \code{\link{rcomp}}. 
}
\seealso{
  \code{\link{clr}},\code{\link{acomp}},\code{\link{rcomp}}
}
\references{
  Aitchison, J. (1986) \emph{The Statistical Analysis of Compositional
    Data} Monographs on Statistics and Applied Probability. Chapman &
  Hall Ltd., London (UK). 416p.
  

}
\note{\code{clo} can be used to unclass compositions.}
\examples{
(tmp <- clo(c(1,2,3)))
clo(tmp,total=100)
data(Hydrochem)
cdata <- Hydrochem[,6:19]
plot( clo(Hydrochem,8:9) ) # Giving a points on a line 

}
\keyword{multivariate}
