\name{aplusarithm}
\alias{+.aplus}
\alias{-.aplus}
\alias{*.aplus}
\alias{/.aplus}
\alias{perturbe.aplus}
\alias{power.aplus}
\title{vectorial arithmetic for datasets with aplus-scale}
\description{
  The positive vectors equiped with the perturbation, defined as
  elementwise product, as +  and powertransform, defined as elementwise
 powering with a scalar, as scalar multiplication forms a real vector
 space. These vector space operations are defined here in a way similar
 to \code{\link{+.rmult}}.
}
\synopsis{
perturbe.aplus(x,y)
x\method{+}{aplus}y
x\method{-}{aplus}y
x\method{*}{aplus}y
x\method{/}{aplus}y
power.aplus(x,r)
}
\usage{
perturbe.aplus(x,y)
   x+y
   x-y
   -x
   x*r
   r*x
   x/r
power.aplus(x,r)
}
\arguments{
  \item{x}{an rmult vector or dataset of vectors }
  \item{y}{an rmult vector or dataset of vectors }
  \item{r}{a numeric vector of size 1 or nrow(x)}
}
\value{
  an object of class \code{"rmult"} containing the result of the
  corresponding operation on the vectors.  
}
\details{
  
  
  The operators try to minic the parallel operation of r on vectors of
real numbers on vectors of vectors represented as matrices containing
the vectors as rows and works like the operators for \code{{\link{rmult}}} 

}
\seealso{
  \code{\link{rmult}}, \code{\link{\%*\%.rmult}}
}

\examples{
x <- aplus(matrix( sqrt(1:12), ncol= 3 ))
x
x+x
x + aplus(1:3)
x * 1:4
1:4 * x
x / 1:4
x / 10
power.aplus(x,1:4)
}
\keyword{multivariate}
