\name{aplus}
\alias{aplus}
\title{Amounts analysed in log-scale}
\description{
  A class to analyse positive amounts in a logistic framework.
}
\usage{
          aplus(X,parts=1:NCOL(X),total=NA)
          }
\arguments{
  \item{X}{vector or dataset of positive numbers}
  \item{parts}{vector containing the indices  xor names of the columns to be used}
  \item{total}{a numeric vectors giving the total amounts of each dataset. }
}
\value{
  a vector of class \code{"aplus"} representing one vector of amounts
  or a matrix of class \code{"aplus"} representing
  multiple vectors of amounts each in one row.  
}
\details{
  Many multivariate datasets essentially discribe amounts of D different
  parts in a whole. When the whole is large in relation to the
  considered parts, such that they don't extrude each other, and when
  the total amount of each componenten is indeed determined by the
  phenomenon under investigation and not by artefacts such as dilution
  or sample preparation, then the parts can be treated as amounts rather
  than as a composition (cf. \code{\link{acomp}}, \code{\link{rcomp}}).
  \cr
  Like compositions amounts have some important properties: Amounts are
  always positive. An amount of exactly zero essentially means that we have a
  substance of an other quality. Different amounts - spanning different
  orders of magnitude  -  are often given in
  different units (ppm, ppb, \%) and conversion factors need not to be
fixed (e.g. for ppm, g/l, vol.\%, mass.\%, molar
  fraction). Often these amounts are only indicators for larger amounts
  of (e.g.  potassium as indicator for kalifeldspar, which itself
  indicates the amount from a specific source region). Thus the analysis
  should be independent of the absolute values and only rely on changes
  of ratios. However in contrast to compositions ratios of amounts
  between different samples do matter. Amounts are typically heavly
  skewed and in many practical cases a log-transform makes their
  distribution roughly symmetric and normal.
  \cr
  In full analogy to Aitchisons compositions we can introduce vector
  space like operations for vectors of positve values: The perturbation
  \code{\link{perturbe.aplus}} as a vector space addition corresponding
  to simple change of units, the power transformation
  \code{\link{power.aplus}} as scalar multiplication discribing the law
  of mass action, and a distance \code{\link{dist.aplus}} which is
  independent of the choosen units. The induced vector space is mapped
  isometrically to a classical \eqn{R^D} by a simple log-Transformation called
  \code{\link{ilt}} resembling classical log transform approaches.  
  \cr
  The general approach in analysing aplus objects is thus to performe
  classical multivariate analysis on ilt-transformed coordinates
  and to backtransform or display the results in such a way that they
  can be interpreted in terms of the original amounts.   
  \cr
  The class aplus is complemented by the \code{\link{rplus}} allowing to
  analyse amounts directly as real numbers, and by the classes
  \code{\link{acomp}} and \code{\link{rcomp}} to analyse the same data
  as compositions disregarding the total amounts focussing on relative
  amounts only.
  \cr
  The classes rcomp, acomp, aplus, and rplus are designed as similar as
  possible in order to allow direct comparison between results achieved  
  by the different approaches. Especially the acomp simplex transforms
  \code{\link{clr}}, \code{\link{alr}}, \code{\link{ilr}} are mirrored
  by the single bijective isometric transform \code{\link{ilt}}

}
\seealso{
  \code{\link{ilt}},\code{\link{acomp}}, \code{\link{rplus}},
  \code{\link{princomp.aplus}}, \code{\link{ClusterAnalysis.aplus}},
  \code{\link{plot.aplus}}, \code{\link{boxplot.aplus}},
  \code{\link{barplot.aplus}}, \code{\link{mean.aplus}},
  \code{\link{var.aplus}}, \code{\link{variation.aplus}},
  \code{\link{cov.aplus}}, \code{\link{msd.aplus}}
}

\references{

}
\examples{
data(SimulatedAmounts)
plot(aplus(sa.lognormals))
}
\keyword{multivariate}
