\name{acompmargin}
\alias{acompmargin}
\title{Marginal compositions in Aitchison Compositions}
\description{
  Compute marginal compositions by amalgamating the rest as its
  geometric mean.
}
\usage{
          acompmargin(X,d=c(1,2),name="*",pos=length(d)+1)
          }
\arguments{
  \item{X}{composition or dataset of compositions}
  \item{d}{vector containing the indices xor names of the columns to be kept}
  \item{name}{The new name of the amalgamation column}
  \item{pos}{The position where the new amalgamation column should be
    stored. This defaults to the last column.}
}
\value{
  A closed compositions with class \code{"acomp"} containing the
  variables given by \code{d} and the the amalgamation column.  }
\details{ The amalgamation column is simply computed by taking the
  geometric mean of the rest of the components. This approach is
consistent with the \code{\link{acomp}} approach and gives clear ternary
diagrams. Anyway the geometric mean is difficult to interpret.
}
\seealso{ \code{\link{rcompmargin}}, \code{\link{acomp}}
}
\references{
  Vera Pawlowsky-Glahn (2003) personal communication. xxx
}
\examples{
data(SimulatedAmounts)
plot.acomp(sa.lognormals5,margin="acomp")
plot.acomp(acompmargin(sa.lognormals5,c("Pb","Zn")))
plot.acomp(acompmargin(sa.lognormals5,c(1,2)))
}
\keyword{multivariate}
