\name{acomp}
\alias{acomp}
\title{Aitchison compositions}
\description{
  A class providing the means to analyse compositions in the
  philosophical framework of the Aitchison Simplex.
}
\usage{
          acomp(X,parts=1:NCOL(X),total=1)
          }
\arguments{
  \item{X}{composition or dataset of compositions}
  \item{parts}{vector containing the indices xor names of the columns to be used}
  \item{total}{the total amount to be used, typically 1 or 100}
}
\value{
  a vector of class \code{"acomp"} representing one closed (to total)
compositions
  or a matrix of class \code{"acomp"} representing
  multiple closed compositions each in one row.  }

\details{
  Many multivariate datasets essentially discribe amounts of D different
  parts in whole. This has some important implications justifying to
  regard them as a scale for its own, called a
  composition. This scale  was in depth analysed by Aitchison
  (1986) and the functions around the class \code{"acomp"} follow his
  approach.\cr
  Compositions have some important properties: Amounts are always
  positive. The amount of every part is limited by the whole. The
  absolute amount of the whole is noninformative since it is typically due
  to artefacts of the measurement procedure. Thus only relative changes
  are relevant. If the relative amount of one part
  increases, the amounts of other parts must decrease, introducing
  spurious anticorrelation (Chayes 1960), when analysed directly. Often
  parts (e.g H2O, Si) are missing in the dataset leaving the total
  amount unreported and longing for analysis procedures avoiding
  artefacts when applied to such subcompositions. Further the analysis
  should be indepent of the units (ppm, g/l, vol.\%, mass.\%, molar
  fraction)
  \cr
  From these properties Aitchison proved mathematically that the
  analysis should be based on ratios or log ratios only. He introduced 
  several transformations (e.g. \code{\link{clr}},\code{\link{alr}}),
  operations (e.g. \code{\link{perturbe}}, \code{\link{power.acomp}}),
  and a distance (\code{\link{dist.acomp}}) which are compatible
with these
  properties. Later () it was found that the set compostions equiped with
  perturbations as addition and powertransform as scalar multiplication
  and the \code{\link{dist.acomp}} as distance form a D-1 dimensional
  euclidean vector space, which can be mapped isometrically to a usual
  vector space by \code{\link{ilr}}.
  \cr
  The general approach in analysing acomp objects is thus to performe
  classical multivariate analysis on clr/alr/ilr-transformed coordinates
  and to backtransform or display the results in such a way that they
  can be interpreted in terms of the original compositional parts.   
  \cr
  A sideeffect of the procedure is to force the compositions to sum to
  \var{total} like it is done by the closure  operation \code{\link{clo}} . 
}
\seealso{
  \code{\link{clr}},\code{\link{rcomp}}, \code{\link{aplus}},
  \code{\link{princomp.acomp}}, \code{\link{ClusterAnalysis.acomp}},
  \code{\link{plot.acomp}}, \code{\link{boxplot.acomp}},
  \code{\link{barplot.acomp}}, \code{\link{mean.acomp}},
  \code{\link{var.acomp}}, \code{\link{variation.acomp}},
  \code{\link{cov.acomp}}, \code{\link{msd.acomp}}
}

\references{
  Aitchison, J. (1986) \emph{The Statistical Analysis of Compositional
    Data} Monographs on Statistics and Applied Probability. Chapman &
  Hall Ltd., London (UK). 416p.\cr

  Aitchison, J, C. Barcel'o-Vidal, J.J. Egozcue, V. Pawlowsky-Glahn
  (2002) A consise guide to the algebraic geometric structure of the
  simplex, the sample space for compositional data analysis, \emph{Terra
    Nostra}, Schriften der Alfred Wegener-Stiftung, 03/2003\cr

  Pawlowsky-Glahn, V. and J.J. Egozcue (2001) Geometric approach to
  statistical analysis on the simplex. \emph{SERRA} \bold{15}(5), 384-398\cr
  
  \url{http://ima.udg.es/Activitats/CoDaWork03}\cr
  
  \url{http://ima.udg.es/Activitats/CoDaWork05}

}
\examples{
data(SimulatedAmounts)
plot(acomp(sa.lognormals))
}
\keyword{multivariate}
