
princomp.acomp <- function(x,...) {
  princomp(clr(x),...)
}

princomp.rcomp <- function(x,...) {
  princomp(cpt(x),...)
}

princomp.aplus <- function(x,...) {
  princomp(ilt(x),...)
}

princomp.rplus <- function(x,...) {
  princomp(iit(x),...)
}

plot.princov.acomp <- function(x,...) {
  n <- length(x$sdev)-1
  plot(1:n,x$sdev[1:n],typ="b",...)
}

print.princov.acomp <- function(x,...) {
  cat("Call:\n")
  print(x$call)
  print(summary(x),...)
}

summary.princov.acomp <- function(object,...) {
  vari <- object$sdev^2 / sum(object$sdev^2)
  list(Importance=
       rbind("Standard Deviation"=object$sdev,
             "Portion of Varianz"=vari,
             "Cumulated Portion" =cumsum(vari)),
       xPerturbation = object$xDirection*nrow(object$xDirection),
       yPerturbation = object$yDirection*nrow(object$yDirection)
       )      
}

biplot.princov.acomp <- function(x,choice=1:2,...) {
  biplot(x$xScores[,choice],rbind(x$xLoadings,x$yLoadings)[,choice],...)
}

princov.acomp <- function(x,y,...,scores=TRUE) {
  clrX <- clr(x)
  clrY <- clr(y)
  A <- cov(clrX,clrY,...)
  sv <- svd(A)
  cnames <- paste("Comp.",1:length(sv$d))
  names(sv$d)<- cnames
  xMean <- mean.acomp(x)
  yMean <- mean.acomp(y)
  xDirection <- apply(sv$u%*% diag(sqrt(sv$d)),2,clr.inv)
  yDirection <- apply(sv$v%*% diag(sqrt(sv$d)),2,clr.inv)
  row.names(xDirection) <- colnames(x)
  row.names(yDirection) <- colnames(y)
  colnames(xDirection) <- cnames
  colnames(yDirection) <- cnames
  xScores <- scale(clrX,scale=FALSE) %*% sv$u
  yScores <- scale(clrY,scale=FALSE) %*% sv$v
  colnames(xScores) <- cnames
  colnames(yScores) <- cnames
  row.names(sv$u) <- colnames(x)
  row.names(sv$v) <- colnames(y)
  colnames(sv$u)  <- cnames
  colnames(sv$v)  <- cnames
  row.names(xDirection) <- colnames(x)
  row.names(yDirection) <- colnames(y)
  colnames(xDirection)  <- cnames
  colnames(yDirection)  <- cnames
  
  structure(list(sdev=sqrt(sv$d),
       xLoadings  =sv$u,
       yLoadings  =sv$v,
       xCenter = clr(mean.acomp(X)),
       yCenter = clr(mean.acomp(Y)),
       xDirection=xDirection,
       yDirection=yDirection,
       xMean     =xMean,
       yMean     =yMean,
       xScores = xScores,
       yScores = yScores,
       call    = match.call()),class="princov.acomp")
       
}

princomp.acomp <- function(x,...,scores=TRUE) {
  clrX <- clr(x)
  A <- cov(clrX,...)
  sv <- svd(A)
  cnames <- paste("Comp.",1:length(sv$d))
  names(sv$d)<- cnames
  xMean <- mean.acomp(x)
  xDirection <- apply(sv$u%*% diag(sqrt(sv$d)),2,clr.inv)
  row.names(xDirection) <- colnames(X)
  colnames(xDirection) <- cnames
  xScores <- scale(clrX,scale=FALSE) %*% sv$u
  colnames(xScores) <- cnames
  row.names(sv$u) <- colnames(x)
  colnames(sv$u)  <- cnames
  row.names(xDirection) <- colnames(x)
  colnames(xDirection)  <- cnames
  
  structure(list(sdev=sqrt(sv$d),
       Loadings  =sv$u,
       Center = clr(mean.acomp(x)),
       Direction=xDirection,
       Mean     =xMean,
       Scores = xScores,
       call    = match.call()),class="princomp.acomp")
       
}

plot.princomp.acomp <- function(x,...) {
  n <- length(x$sdev)-1
  plot(1:n,x$sdev[1:n],typ="b",...)
}

print.princomp.acomp <- function(x,...) {
  cat("Call:\n")
  print(x$call)
  print(summary(x),...)
}

summary.princomp.acomp <- function(object,...) {
  vari <- object$sdev^2 / sum(object$sdev^2)
  list(Importance=
       rbind("Standard Deviation"=object$sdev,
             "Portion of Varianz"=vari,
             "Cumulated Portion" =cumsum(vari)),
       Perturbation = object$Direction*nrow(object$Direction),
       )      
}

biplot.princomp.acomp <- function(x,choice=1:2,...) {
  biplot(x$Scores[,choice],x$Loadings[,choice],...)
}


panel.princomp.acomp <- function(x,choice,t,...){
  lines.panel.acomp(x$Mean,x$Direction)
}


gsi <- function() {}


